#!/usr/bin/env python
# -*- coding: utf-8 -*-
import os, sys, site 
import datetime
import urllib
import urlparse
import re

import web
from web.contrib.template import render_mako

from mako.template import Template

from mako.lookup import TemplateLookup

from bs4 import BeautifulSoup
import sqlite3dbm

from config import *
from utils import *

tlookup = TemplateLookup(   directories=[PANEO_SITE_DATA_DIR],
                            input_encoding='utf-8',
                            output_encoding='utf-8',
                            encoding_errors='replace'   ) 

from bottlenose import api
AMAZON_API = api.Amazon(AWS_KEY, SECRET_KEY, ASSOCIATE_TAG, Region="JP")

def GetAmazonItem( i ):
    feature = ""
    for f in i.findAll("feature"):
        feature = feature + f.string + "\n"
    item = {
    'associate':    ASSOCIATE_TAG, 
    'asin':         i.find('asin').string if i.find('asin') else "",
    'title':        i.find('title').string if i.find('title') else "",
    'content':      i.find('content').string if i.find('content') else "",
    'availability': i.find('availability').string if i.find('availability') else "",
    'price':        i.find('price').find('amount').string if i.find('price').find('amount') else "",
    'label':        i.find('label').string if i.find('label') else "",
    'binding':      i.find('binding').string if i.find('binding') else "",
    'brand':        i.find('brand').string if i.find('brand') else "",
    'feature':      feature,
    'imagesets':    i.find('imagesets'),
    }
    return item 

def GetImageWidth( x ):
    ua = web.ctx.env['HTTP_USER_AGENT'].lower()
    if ua.find('paneo') != -1:
        return 0 
    if ua.find('iphone') != -1:
        x = 640 
    elif ua.find('ipod') != -1:
        x = 640
    elif ua.find('android') != -1:
        x = 640 
    elif ua.find('ipad') != -1:
        x = 1280 
    else:
        x = 1536 
    return x


def GeneTemplate( id ):

        OFFLINE = False
        if id == "offline":
            id = "index"
            OFFLINE = True

        dic = sqlite3dbm.sshelve.open(PANEO_DB)
        scfg = dic.get('siteconfig')
        pages = dic.get('pages')
        fields = dic.get('fields')
        dic.close()

        #not found
        if not pages.has_key(id):
            raise web.notfound()

        try:
            file = codecs.open(PANEO_SITE_DATA_DIR+id+'.html',"r","utf8")
            html = file.read()
            html = html.replace('<%include file="_meta.html"/>','')
            #bs = BeautifulSoup(html,"html5lib",fromEncoding="utf8")
            bs = BeautifulSoup(html,fromEncoding="utf8")
            file.close()
        except:
            return web.notfound()

        try:
            if pages.has_key(id):
                if pages[id].get('TITLE') and id != 'index':
                    bs.title.string = pages[id].get('TITLE') + ' | ' + scfg.get('SITENAME')
                else:
                    bs.title.string = scfg.get('SITENAME')
            else:
                    bs.title.string = bs.title.string + ' | ' + scfg.get('SITENAME')
        except:
            pass

        #OFFLINE TAG
        if OFFLINE :
            bs.html["manifest"] = "site.appcache"
            soup = BeautifulSoup('<div id="output" style="font-size:20px;padding:10px;">offline</div>')
            tag = soup.div
            bs.select('div#container')[0].insert_before(tag)

        #UA APPEND
        ua = web.ctx.env['HTTP_USER_AGENT'].lower()

        #soup = BeautifulSoup('<div id="ua" style="font-size:20px;padding:10px;">%s</div>' % ua)
        #tag = soup.div
        #bs.select('div#container')[0].insert_before(ua)

        #SWIPE SCRIPT INSERT
        try:
            if ua.find('ipad') != -1 or ua.find('iphone') != -1 or ua.find('android') != -1:
                #bs.html["manifest"] = "site.appcache"
                soup = BeautifulSoup('<script type="text/javascript" src="/common/js/ipad.js"></script>') 
                bs.select('div#container')[0].insert_after(soup.script)
                soup = BeautifulSoup('<script type="text/javascript" src="/common/js/jquery.touchSwipe.js"></script>')
                bs.select('div#container')[0].insert_after(soup.script)
                pager = "<script>\n<!--\n"
                p = [] 
                for k,v in sorted(pages.items(),key=lambda x:int(x[1].get('IDX'))):
                    p.append(k)
                prev = ""
                next = ""
                for c,v in enumerate(p) :
                    if v == id :
                        if id == 'index':
                            prev = p[-1]
                        else:
                            prev = p[c-1]
                        if c < len(p) - 1:
                            next = p[c+1]
                        else:
                            next = p[0]
                pager += "var prev = '%s';\nvar next = '%s';\n--></script>" % ( prev , next )
                soup = BeautifulSoup(pager) 
                bs.select('div#container')[0].insert_after(soup.script)
        except:
            pass

        PANEO = False
        if ua.find('paneo') != -1 :
            PANEO = True

        #CONTENTS and IMAGE Set
        if fields is None:
            fields = {}

        #H* TAG
        for h in bs.find_all(re.compile("h['1','2','3','4','5']")):
            paneo_type = h.get('data-paneo-type')
            paneo_name = h.get('data-paneo-name')
            if paneo_type is not None and paneo_name is not None:
                k = ('h_%s_%s'%(id,paneo_name))
                f = fields.get(k)
                if paneo_type == "text" :
                    if f :
                        h.string = f.get('string')
      
        #P TAG
        for p in bs.find_all('p'):
            paneo_type = p.get('data-paneo-type')
            paneo_name = p.get('data-paneo-name')
            if paneo_type is not None and paneo_name is not None:
                k = ('p_%s_%s'%(id,paneo_name))
                f = fields.get(k)
                if paneo_type == "text" or paneo_type == 'textarea':
                    if f :
                        p.clear()
                        new_tag = bs.new_tag('div')
                        if p.has_key('class'):
                            new_tag['class'] = p['class']
                        if p.has_key('style'):
                            new_tag['style'] = p['style']
                        new_tag_p = bs.new_tag('p')
                        new_tag_p.append(f.get('string').replace("\r\n","")) 
                        new_tag.append(new_tag_p) 
                        #p.append(new_tag)
                        p.replace_with(new_tag)

        #IMG TAG
        x = GetImageWidth(0)
        for img in bs.find_all("img"):
            paneo_type = img.get('data-paneo-type')
            paneo_name = img.get("data-paneo-name")
            paneo_max_width = img.get("data-paneo-max-width")
            if paneo_type is not None and paneo_name is not None:
                k = ('img_%s_%s'%(id,paneo_name))
                f = fields.get(k)
                if f :
                    if os.path.exists(PANEO_SITE_DATA_DIR+'img/'+k) :
                        if f.get('src_on') == False :
                            if IMG_CONV :
                                if os.path.exists( PANEO_SITE_DATA_DIR + 'cache/img_%s_%s' % ( x, k ) ):
                                    img["src"] = "/" + PANEO_SITE_DIR + "/cache/img_%s_%s" % ( x , k )
                                else:
                                    if paneo_max_width :
                                        img["src"] = "/img/%s/%s/" % ( k , paneo_max_width )
                                    else:
                                        img["src"] = "/img/" + k
                            else:
                                img["src"] = "/" + PANEO_SITE_DIR + "/img/" + k
                        else:
                            if f :
                                img["src"] = f.get('src') 
                    else:
                        if f.get('src_on') == True:
                            img["src"] = f.get('src') 

                    img["alt"] = f.get('alt')

        #ANCHOR TAG
        for a in bs.find_all('a'):
            paneo_type = a.get('data-paneo-type')
            paneo_name = a.get('data-paneo-name')
            if paneo_type is not None and paneo_name is not None:
                k = ('img_%s_%s'%(id,paneo_name))
                f = fields.get(k)
                if paneo_type == "text-link":
                    if f :
                        a.string = f.get('string')
                        a['href'] = f.get('href')

                if paneo_type == "link-image":
                    img = a.find("img")
                    paneo_max_width = img.get("data-paneo-max-width")
                    if f and img :
                        a['href'] = f.get('href')
                    if f:
                        if os.path.exists(PANEO_SITE_DATA_DIR+'img/'+k) :
                            if f.get('src_on') == False :
                                if IMG_CONV :
                                    if os.path.exists( PANEO_SITE_DATA_DIR + 'cache/img_%s_%s' % ( x, k ) ):
                                        img["src"] = "/" + PANEO_SITE_DIR + "/cache/img_%s_%s" % ( x , k )
                                    else:
                                        if paneo_max_width :
                                            img["src"] = "/img/%s/%s/" % ( k , paneo_max_width )
                                        else:
                                            img["src"] = "/img/" + k
                                else:
                                    img["src"] = "/" + PANEO_SITE_DIR + "/img/" + k 
                            else:
                                if f :
                                    img["src"] = f.get('src') 
                        else:
                            if f.get('src_on') == True:
                                img["src"] = f.get('src') 

                    if f:
                        img["alt"] = f.get('alt')

        #AWS TAG ITEM
        amas =  bs.find_all(attrs={'data-paneo-type':'amazon','data-paneo-amazon':'item'})
        for ama in amas:
            paneo_name = ama.get('data-paneo-name')
            title = ama.get('title')
            if paneo_name is not None:
                k = ('ama_%s_%s'%(id,paneo_name))
                f = fields.get(k)
                if f :
                    ama_asin = f.get('asin') 
                    itemid = ""
                    for ii in range(1,11):
                        asin = ama_asin.get("I:%s"%ii)
                        if asin != "": 
                            itemid = itemid + "%s," % asin

                    response = AMAZON_API.ItemLookup(   ItemId=itemid,
                                                        ResponseGroup="Large"   )
                    ama_bs = BeautifulSoup(response,fromEncoding="utf8")
                    items = []
                    for i in ama_bs.findAll("item"):
                        items.append( GetAmazonItem( i ) )
                    ama_template = PANEO_SITE_DATA_DIR+'_aws_item.html'
                    if not os.path.exists(ama_template):
                        ama.string = "<div>_aws_item.html not found</div>"
                    else:
                        if os.path.exists(PANEO_SITE_DATA_DIR+'_aws_%s.html'%paneo_name) :
                            ama_template = PANEO_SITE_DATA_DIR+'_aws_%s.html'%paneo_name
                        temp = Template(    filename=ama_template, 
                                          output_encoding='utf-8',
                                          input_encoding='utf-8' )
                         
                        ama_html = temp.render( items = items, PANEO = PANEO ) 
                        ama.string = ama_html


        #AWS TAG SEARCH
        amas =  bs.find_all(attrs={'data-paneo-type':'amazon','data-paneo-amazon':'search'})
        for ama in amas:
            paneo_name = ama.get('data-paneo-name')
            title = ama.get('title')
            if paneo_name is not None:
                k = ('ama_%s_%s'%(id,paneo_name))
                f = fields.get(k)
                if f :
                    ama_searchindex = f.get('searchindex') 
                    ama_kw = f.get('kw') 
                    ama_itempage = f.get('itempage') 
                    ama_sort = f.get('sort') 
                    response = AMAZON_API.ItemSearch(   SearchIndex=ama_searchindex,
                                                        Keywords=ama_kw,
                                                        ItemPage=ama_itempage,
                                                        ResponseGroup="Large",
                                                        Sort=ama_sort   )
                    ama_bs = BeautifulSoup(response,fromEncoding="utf8")
                    items = []
                    for i in ama_bs.findAll("item"):
                        items.append( GetAmazonItem( i ) )
                    ama_template = PANEO_SITE_DATA_DIR+'_aws_search.html'
                    if not os.path.exists(ama_template):
                        ama.string = "<div>_aws_search.html not found</div>"
                    else:
                        if os.path.exists(PANEO_SITE_DATA_DIR+'_aws_%s.html'%paneo_name) :
                            ama_template = PANEO_SITE_DATA_DIR+'_aws_%s.html'%paneo_name
                        temp = Template(    filename=ama_template, 
                                          output_encoding='utf-8',
                                          input_encoding='utf-8' )
                         
                        ama_html = temp.render( items = items, PANEO = PANEO ) 
                        ama.string = ama_html

        #MAKE TEMPLATE
        t = unicode(bs)
        t = t.replace("<head>",'\r\n<head>')
        rep_head = '<%include file="_meta.html"/><link rel="stylesheet" href="//${web.ctx.host}/' + id + '.css" media="all"/>\n</head>'
        t = t.replace("</head>",rep_head)
        t = t.replace("&lt;","<")
        t = t.replace("&gt;",">")
        t = t.replace("&amp;","&")
        t = t.replace("<br>","<br/>")

        return [scfg,pages,fields,t]



class ViewHTML:

    def __init__(self):
        web.header("Content-Type", "text/html; charset=UTF-8")
        #web.header("Cache-Control", "no-cache, must-revalidate")
        #web.header("Pragma", "no-cache")

    def offline( self ):
        ua = u"""
        <script type="text/javascript">
        window.applicationCache.addEventListener('checking', function() {
        document.getElementById('output').innerHTML = '更新のチェック中...';
        }, false);

        window.applicationCache.addEventListener('noupdate', function() {
        document.getElementById('output').innerHTML = '[更新はありません]';
        }, false);

        window.applicationCache.addEventListener('updateready', function() {
        document.getElementById('output').innerHTML = '[更新しました]';
        applicationCache.swapCache();
        }, false);

        window.applicationCache.addEventListener('downloading', function() {
        document.getElementById('output').innerHTML = 'ダウンロード中...';
        }, false);

        window.applicationCache.addEventListener('cached', function() {
        document.getElementById('output').innerHTML = '[すべてのリソースがキャッシュ済みです]';
        }, false);

        window.applicationCache.addEventListener('error', function() {
        document.getElementById('output').innerHTML = '[エラーが発生しました]';
        }, false);

        window.applicationCache.update();
        </script>
        """
        return ua;

    def GET( self, id = "index" ):

        #try:
        if True:
            scfg,pages,fields,t = GeneTemplate( id )

            template = Template(    
                                    t,
                                    lookup=tlookup,
            )

            ua_option = ""
            if id == "offline":
                web.header("Cache-Control", "no-cache, must-revalidate")
                web.header("Pragma", "no-cache")
                ua_option += self.offline(); 

            html = template.render(
                                    id = id,
                                    web = web,
                                    session = web.ctx.session,
                                    scfg = scfg, 
                                    pages = pages,
                                    ua_option = ua_option,
            )
        #except:
        #    raise web.notfound()

        return html

    def POST( self, id = "index" ):

            #FORM処理
            return "POST" 

class ViewCSS:

    def __init__(self):
        web.header("Content-Type", "text/css; charset=UTF-8")

    def GET( self, id = "index" ):

        dic = sqlite3dbm.sshelve.open(PANEO_DB)
        scfg = dic.get('siteconfig')
        pages = dic.get('pages')
        fields = dic.get('fields')
        dic.close()

        #not found
        if not pages.has_key(id):
            raise web.notfound()

        try:
            file = codecs.open(PANEO_SITE_DATA_DIR+id+'.html',"r","utf8")
            html = file.read()
            html = html.replace('<%include file="_meta.html"/>','')
            bs = BeautifulSoup(html,"html5lib",fromEncoding="utf8")
            file.close()
        except:
            return web.notfound()

        css = "/* PANEO %s CSS */\r\n" % id 

        bks =  bs.find_all(attrs={'data-paneo-type':'background'})
        for bk in bks:
            bk_id = bk.get('id')

            if bk.name == 'body':
                bk_id = 'body'

            bk_title = bk.get('title')
            bk_url = bk.get('data-paneo-background-url')
            if bk_url is None:
                bk_url = ""
            if bk_id is not None :
                k = ('bk_%s_%s_img'%(id,bk_id))
                f = fields.get(k)

                if bk.name == 'body':
                    css = css + ( 'body {\r\n')
                else:
                    css = css + ( bk.name + '#' + bk_id + ' {\r\n')

                if f :
                    bk_src_on = f.get('src_on') 
                    bk_size = f.get('size') 
                    bk_repeat = f.get('repeat') 
                    bk_position = f.get('position') 
                    bk_etc = f.get('etc') 
                else:
                    bk_src_on = False 
                    bk_size = "contain"
                    bk_repeat = "no-repeat"
                    bk_position = "0 0"
                    bk_etc = ""

                if os.path.exists(PANEO_SITE_DATA_DIR+'img/'+k) :
                    if bk_src_on == False :
                        if IMG_CONV :
                            bk_url = "/img/" + k
                        else:
                            bk_url = "/" + PANEO_SITE_DIR + "/img/" + k
                    else:
                        if f :
                            bk_url = f.get('src') 
                else:
                    if bk_src_on:
                        bk_url = f.get('src') 

                css = css + 'background-image:url(' + bk_url + ');\r\n'
                css = css + 'background-size:' + bk_size + ';\r\n'
                css = css + 'background-repeat:' + bk_repeat + ';\r\n'
                css = css + 'background-position:' + bk_position + ';\r\n'

                if bk_etc :
                    css = css + str(bk_etc) + ';\r\n'

                css = css + '}\r\n'

        return css 


#HTML5 Offline Manifest site.appcache
class AppCache:

    def GET( self ):
        manifest = """CACHE MANIFEST
# Explicitly cached 'master entries'.
# VERSION %s
CACHE:
${ cache }

# Resources that require the user to be online.
NETWORK:
${ network }

# static.html will be served if main.py is inaccessible
# offline.jpg will be served in place of all images in images/large/
# offline.html will be served in place of all other .html files
FALLBACK:
${ fallback }
        """ % datetime.datetime.today().strftime("%Y%m%d")
    
        dic = sqlite3dbm.sshelve.open(PANEO_DB)
        scfg = dic.get('siteconfig')
        pages = dic.get('pages')
        fields = dic.get('fields')
        dic.close()

        cache = ""
        for k,v in sorted(pages.items(),key=lambda x:int(x[1].get('IDX'))):
            if k == 'index':
                cache = cache + ("/\r\n")
                cache = cache + ("/%s.html\r\n" % k)
                cache = cache + ("/%s.css\r\n" % k)
            else:
                cache = cache + ("/%s.html\r\n" % k)
                cache = cache + ("/%s.css\r\n" % k)
            _scfg,_pages,_fields,_t = GeneTemplate( k )

            template = Template(    
                                    _t,
                                    lookup=tlookup,
            )

            ua_option = ""
            txt = template.render(
                                    id = k,
                                    web = web,
                                    session = web.ctx.session,
                                    scfg = _scfg, 
                                    pages = _pages,
                                    ua_option = ua_option,
            )
            bs = BeautifulSoup(txt,"html5lib",fromEncoding="utf8")

            for t in bs.find_all("img"):
                cache = cache + ("%s\r\n" % t["src"])

            #for t in bs.find_all("video"):
            #    if t.has_key("src"):
            #        cache = cache + ("%s\r\n" % t["src"])

            #for t in bs.find_all("source"):
            #    if t.has_key("src"):
            #        cache = cache + ("%s\r\n" % t["src"])

            if k == "index" :
                cache = cache + "/common/css/reset.css\r\n"
                cache = cache + "/common/css/debug.css\r\n"

                for src in bs.find_all("link"):
                    if src.has_key("href"):
                        cache = cache + ("%s\r\n" % src["href"])

                for src in bs.find_all("script"):
                    if src.has_key("src"):
                        cache = cache + ("%s\r\n" % src["src"])

        network = "/offline.html"
        fallback = ""

        web.header("Content-Type", "text/cache-manifest")
        web.header("Cache-Control", "no-cache, must-revalidate")
        web.header("Pragma", "no-cache")

        return  Template( manifest ).render(    cache = cache,
                                                network = network,
                                                fallback = fallback, )


from PIL import Image
from cStringIO import StringIO

class ViewImage:

    def GET( self, file = None , x = 0):

        img_file = PANEO_SITE_DATA_DIR + 'img/' + file

        try:
            if x == 0:
                x = GetImageWidth(x)
                if x == 0:
                    img = open(img_file,"rb").read()
                    web.header("Content-Length", len(img))
                    return img

            fo = StringIO()
            if os.path.exists( PANEO_SITE_DATA_DIR + 'cache/img_%s_%s' % ( x, file ) ):
                img = open( PANEO_SITE_DATA_DIR + 'cache/img_%s_%s' % ( x, file ) ,"rb").read()
                web.header("Content-Length", len(img))
                return img

            img = Image.open(img_file) 
            xx = img.size[1]
            yy = img.size[0]

            sc = float(x) / float(yy)
            y = int(img.size[1] *sc)

            img.thumbnail( (x, y ), Image.ANTIALIAS )
            #caching
            img.save(PANEO_SITE_DATA_DIR + 'cache/img_%s_%s' % ( x ,file), img.format, quality=80)
            img.save(fo, img.format, quality=80)

            web.header("Content-Type", "image/%s; charset=UTF-8" % img.format)
            web.header("Content-Length", len(fo))
            return fo.getvalue()

        except:
            img = open(img_file,"rb").read()
            web.header("Content-Length", len(img))
            return img
            
